#!/bin/sh

DPLY_PAGE_SB_NUM_CONF_RESULT_MSG=""
DPLY_PAGE_SB_NUM_CONF_RESULT_OK=0
DPLY_PAGE_SB_NUM_CONF_RESULT_ERROR=1

DPLY_PAGE_SB_NUM_CONF_RESULT_CODE=${DPLY_PAGE_SB_NUM_CONF_RESULT_ERROR}
DPLY_PAGE_SB_NUM_CONF_RESULT_ROLLING=0


dply_page_sb_num_conf() {
    debug_print "in function '${FUNCNAME[0]}'"

    local text=`printf \
            "${DPLY_PAGE_SB_NUM_CONF_TEXT}" \
            "${conf_number_of_sb}"`
            
    local default_number="${RT_SB_NUMBER:-$conf_number_of_sb}"
    tp_inputbox \
        "${DPLY_PAGE_SB_NUM_CONF_TITLE}" \
        "${text}" \
        "${DPLY_PAGE_SB_NUM_CONF_OK_LABEL}" \
        "${DPLY_PAGE_SB_NUM_CONF_CANCEL_LABEL}" \
        "${default_number}"

    if [ "${TP_INPUTBOX_RESULT_CODE}" == "${TP_INPUTBOX_RESULT_CANCEL}" ]; then
    
        # dirty method, to see if only one SandboxController. If yes, rolling -2 page
        local msg
        msg=`php "${CONS_BACKEND}" list_all_esxi_vmx_file \
            "${RT_ESXI_IP}" \
            "${RT_ESXI_USERNAME}" \
            "${RT_ESXI_PASSWORD}" \
            "SandboxController"`
        local ret="${?}"
        if [ "${ret}" -ne 0 ]; then
            DPLY_PAGE_SB_NUM_CONF_RESULT_CODE=$DPLY_PAGE_SB_NUM_CONF_RESULT_ERROR
            DPLY_PAGE_SB_NUM_CONF_RESULT_ROLLING=0
            DPLY_PAGE_SB_NUM_CONF_RESULT_MSG="${msg}"
            return
        fi

        local sc_count=`echo "${msg}" | wc -l`
        if [ "${sc_count}" -eq 1 ]; then
            DPLY_PAGE_SB_NUM_CONF_RESULT_ROLLING=-2
        else
            DPLY_PAGE_SB_NUM_CONF_RESULT_ROLLING=-1
        fi
        
        DPLY_PAGE_SB_NUM_CONF_RESULT_CODE=$DPLY_PAGE_SB_NUM_CONF_RESULT_OK
        DPLY_PAGE_SB_NUM_CONF_RESULT_MSG=""
        return
    fi

    local num_of_sb=`echo "${TP_INPUTBOX_RESULT_DATA}" | sed -n '1p'`
    debug_print "CheckUserDefinedSandboxNumber: UserDefinedSandboxNumber='${num_of_sb}'"
    
    # check 'SandboxNumber': started_with_zero
    echo "${num_of_sb}" | egrep -q '^[1-9][0-9]*$'
    local is_started_with_zero="${?}"
    
    # check 'SandboxNumber': positive and valid
    is_integer_positive_and_valid "${num_of_sb}"
    local is_positive_and_valid="${?}"
    
    if [ "${is_started_with_zero}"  -ne 0 ] || \
       [ "${is_positive_and_valid}" -ne 0 ] || \
       [ "${num_of_sb}" -gt 24 ] || \
       [ "${num_of_sb}" -lt 1 ]; then

        local text=`printf \
                "${DPLY_PAGE_SB_NUM_CONF_INVALID_NUM}" \
                "24"`

        debug_print "CheckUserDefinedSandboxNumberFail: UserDefinedSandboxNumber='${num_of_sb}'"
        debug_print "${text}"
        
        DPLY_PAGE_SB_NUM_CONF_RESULT_CODE=$DPLY_PAGE_SB_NUM_CONF_RESULT_ERROR
        DPLY_PAGE_SB_NUM_CONF_RESULT_ROLLING=0
        DPLY_PAGE_SB_NUM_CONF_RESULT_MSG="${text}"
        return
    fi
    debug_print "CheckUserDefinedSandboxNumberPass: UserDefinedSandboxNumber='${num_of_sb}'"
    
    RT_SB_NUMBER="${num_of_sb}"
    debug_print "RT_SB_NUMBER=${RT_SB_NUMBER}"
    
    DPLY_PAGE_SB_NUM_CONF_RESULT_CODE=$DPLY_PAGE_SB_NUM_CONF_RESULT_OK
    DPLY_PAGE_SB_NUM_CONF_RESULT_ROLLING=1
    DPLY_PAGE_SB_NUM_CONF_RESULT_MSG=""
}